//@input vec4 defaultTextColor {"widget":"color"}
//@input vec4 displayNameTextColor {"widget":"color"}
//@input vec4 currentUserTextColor {"widget":"color"}
//@input int displayNameLength = 15

//@ui {"widget":"group_start", "label":"Entry inputs"}
//@input Component.Text scoreText
//@input Component.Text[] displayNameTexts
//@input Component.Image bitmojiImage
//@input Component.Text place
//@input SceneObject[] entryWithGlobalRankObjects
//@input SceneObject[] entryWithoutGlobalRankObjects
//@input SceneObject medalSceneObject
//@input SceneObject placeSceneObject
//@input Component.Image backgroundImage
//@input Component.Image scoreIconImage
//@input Component.Text globalRankingText
//@input Asset.Texture invisiblePixel
//@ui {"widget":"group_end"}

const displayNameUtils = require("./DisplayNameUtils");

script.setEntryIndex = setEntryIndex;
script.setUserRecord = setUserRecord;
script.setBitmoji = setBitmoji;
script.setEntryBgTextureType = setEntryBgTextureType;

let LeaderboardEntryBgTextureType;
(function(LeaderboardEntryBgTextureType) {
    LeaderboardEntryBgTextureType[LeaderboardEntryBgTextureType["MainSegment"] = 0] = "MainSegment";
    LeaderboardEntryBgTextureType[LeaderboardEntryBgTextureType["MainSegmentBlue"] = 1] = "MainSegmentBlue";
    LeaderboardEntryBgTextureType[LeaderboardEntryBgTextureType["BottomSegment"] = 2] = "BottomSegment";
    LeaderboardEntryBgTextureType[LeaderboardEntryBgTextureType["BottomSegmentBlue"] = 3] = "BottomSegmentBlue";
})(LeaderboardEntryBgTextureType || (LeaderboardEntryBgTextureType = {}));

let currentEntryIndex = 0;
let medalMaterial = null;
let bitmojiMaterial = null;
let backgroundMaterial = null;
let scoreIconMaterial = null;

function setEntryBgTextureType(entryType) {
    switch (entryType) {
        case LeaderboardEntryBgTextureType.MainSegment:
            backgroundMaterial.mainPass.textureSwitcher = 0;
            setColor(false);
            break;
        case LeaderboardEntryBgTextureType.MainSegmentBlue:
            backgroundMaterial.mainPass.textureSwitcher = 1;
            setColor(true);
            break;
        case LeaderboardEntryBgTextureType.BottomSegment:
            backgroundMaterial.mainPass.textureSwitcher = 2;
            setColor(false);
            break;
        case LeaderboardEntryBgTextureType.BottomSegmentBlue:
            backgroundMaterial.mainPass.textureSwitcher = 3;
            setColor(true);
            break;
        default:
            break;
    }
}

function setColor(isCurrentUser) {
    if (isCurrentUser) {
        script.displayNameTexts.forEach((displayNameText) => {
            displayNameText.textFill.color = script.currentUserTextColor;
        });
        script.scoreText.textFill.color = script.currentUserTextColor;

        if (scoreIconMaterial) {
            scoreIconMaterial.mainPass.textureSwitcher = 1;
        }
    } else {
        script.displayNameTexts.forEach((displayNameText) => {
            displayNameText.textFill.color = script.displayNameTextColor;
        });
        script.scoreText.textFill.color = script.defaultTextColor;

        if (scoreIconMaterial) {
            scoreIconMaterial.mainPass.textureSwitcher = 0;
        }
    }
}

function setEntryIndex(entryIndex) {
    if (isNull(entryIndex)) {
        return;
    }

    currentEntryIndex = entryIndex;

    if (entryIndex <= 3 && entryIndex >= 1) {
        script.medalSceneObject.enabled = true;
        script.placeSceneObject.enabled = false;

        if (medalMaterial) {
            medalMaterial.mainPass.textureSwitcher = entryIndex - 1;
        }
    } else {
        script.medalSceneObject.enabled = false;
        script.placeSceneObject.enabled = true;

        const leaderboardPlace = entryIndex;
        const entryIndexString = leaderboardPlace <= 999 ? ("#" + leaderboardPlace) : "999+";

        getPlaceTextComponent().text = entryIndexString;
    }
}

function getMedalImage() {
    return script.medalSceneObject.getComponent("Component.Image");
}

function getPlaceTextComponent() {
    return script.placeSceneObject.getComponent("Component.Text");
}

function setBitmoji(bitmoji) {
    if (!isNull(bitmojiMaterial) && !isNull(bitmoji)) {
        bitmojiMaterial.mainPass.baseTex = bitmoji;
    } else {
        bitmojiMaterial.mainPass.baseTex = script.invisiblePixel;
    }
}

function setUserRecord(userRecord, isGlobalLeaderboard) {
    setDisplayName("");

    if (isNull(userRecord)) {
        return;
    }

    if (!isNull(userRecord.score)) {
        script.scoreText.text = userRecord.score + "";
    }

    if (userRecord.snapchatUser && !isNull(userRecord.snapchatUser.displayName) && userRecord.snapchatUser.displayName !== "") {
        setDisplayName(displayNameUtils.formatDisplayName(userRecord.snapchatUser.displayName, script.displayNameLength) + "");
    } else {
        if (!isGlobalLeaderboard && userRecord.snapchatUser && !isNull(userRecord.snapchatUser.userName)) {
            setDisplayName(userRecord.snapchatUser.userName);
        }
    }

    /* Another design with global exact rank
    if (!isNull(userRecord.globalExactRank) && userRecord.globalExactRank !== 0) {
        setGlobalRankAvailable(true)
        script.globalRankingText.text = "#" + userRecord.globalExactRank
    } else {
        setGlobalRankAvailable(false)
    }
    */
}

function setDisplayName(displayName) {
    script.displayNameTexts.forEach((displayNameText) => {
        displayNameText.text = displayName;
    });
}

function setGlobalRankAvailable(isAvailable) {
    script.entryWithGlobalRankObjects.forEach((entry) => entry.enabled = isAvailable);
    script.entryWithoutGlobalRankObjects.forEach((entry) => entry.enabled = !isAvailable);
}

function initialize() {
    medalMaterial = getMedalImage().mainMaterial.clone();
    getMedalImage().mainMaterial = medalMaterial;

    bitmojiMaterial = script.bitmojiImage.mainMaterial.clone();
    script.bitmojiImage.mainMaterial = bitmojiMaterial;

    backgroundMaterial = script.backgroundImage.mainMaterial.clone();
    script.backgroundImage.mainMaterial = backgroundMaterial;

    scoreIconMaterial = script.scoreIconImage.mainMaterial.clone();
    script.scoreIconImage.mainMaterial = scoreIconMaterial;

    setGlobalRankAvailable(false);
}

initialize();
